﻿using System.ComponentModel;
using System.Numerics;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Windows;
using System.Xml.Serialization;

namespace WpfCSharp.Members
{
    public abstract class CustomBindableBase : DependencyObject, INotifyPropertyChanged
    {
        #region Private Variables

        private Boolean _mute = false;
        private Guid _id = Guid.NewGuid();

        #endregion

        #region Public Clr Properties

        public Boolean Mute { get { return _mute; } set { SetProperty(ref _mute, value); } }
        public Guid Id { get { return _id; } set { SetProperty(ref _id, value); } }

        #endregion

        #region Protected Constructor(s)

        protected CustomBindableBase()
        {

        }

        protected CustomBindableBase(String pluginName)
        {

        }

        #endregion

        #region Public Methods

        public void SetFieldValue(String fieldName, Object classObj, Boolean value)
        {
            PropertyInfo propertyInfo = classObj.GetType().GetProperty(fieldName);
            if (propertyInfo != null)
                propertyInfo.SetValue(classObj, value);
        }

        public void SetFieldValue(String fieldName, Object classObj, BigInteger value)
        {
            PropertyInfo propertyInfo = classObj.GetType().GetProperty(fieldName);
            if (propertyInfo != null)
                propertyInfo.SetValue(classObj, value);
        }

        public void SetFieldValue(String fieldName, Object classObj, Double value)
        {
            PropertyInfo propertyInfo = classObj.GetType().GetProperty(fieldName);
            if (propertyInfo != null)
                propertyInfo.SetValue(classObj, value);
        }

        public void SetFieldValue(String fieldName, Object classObj, String value)
        {
            PropertyInfo propertyInfo = classObj.GetType().GetProperty(fieldName);
            if (propertyInfo != null)
                propertyInfo.SetValue(classObj, value);
        }



        #endregion

        #region Public Functions

        public Object GetFieldValue(String fieldName, Object classObj)
        {
            PropertyInfo propertyInfo = classObj.GetType().GetProperty(fieldName);
            return propertyInfo.GetValue(classObj);
        }

        #endregion

        #region Reflection

        public Object GetThisPropertyValue(String propertyName)
        {
            return this[propertyName];
        }

        public void SetThisPropertyValue(String propertyName, Object value)
        {
            this[propertyName] = value;
        }

        [XmlIgnore]
        public Object this[String propertyName]
        {
            get { return this.GetType().GetProperty(propertyName).GetValue(this, null); }
            set { this.GetType().GetProperty(propertyName).SetValue(this, value, null); }
        }

        #endregion

        #region Public Events

        public event PropertyChangedEventHandler PropertyChanged;

        #endregion

        #region Protected Property Setter

        public Boolean SetProperty<T>(ref T storage, T value, [CallerMemberName] String propertyName = null)
        {
            try
            {
                if (Equals(storage, value)) return false;

                storage = value;
                if (propertyName != null) OnPropertyChanged(propertyName);
            }
            catch (Exception ex)
            {
                String msg = ex.Message;
            }

            return true;
        }

        #endregion

        #region Public Methods

        public void OnPropertyChanged([CallerMemberName] String propertyName = null)
        {
            try { var eventHandler = PropertyChanged; eventHandler?.Invoke(this, new PropertyChangedEventArgs(propertyName)); }
            catch (Exception ex)
            {
                String msg = ex.Message;
            }
        }

        public void NotifyPropertyChanged(String propertyName)
        {
            try { PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName)); }
            catch (Exception ex)
            {
                String msg = ex.Message;
            }
        }

        #endregion
    }
}
